 ; Ŀ
 ;   Bomp - count BOM tag numbers.                                         
 ;   Copyright 2004, 2006 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Croco - draw a temporary marker.                           
 ; 
 (DEFUN CROCO (pa / blip colo colo2 rad rad2)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq colo 140)
  (setq colo2 170)
  (setq rad (/ (getvar "viewsize") 35))
  (setq rad2 (/ (getvar "viewsize") 45))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (/ pi 2) rad) (polar pa (* 1.5 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
  (grdraw (polar pa 0 rad) (polar pa pi rad) colo)
  (grdraw (polar pa (/ pi 8) rad2) (polar pa (* 1.125 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.375) rad2) (polar pa (* 1.375 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.625) rad2) (polar pa (* 1.625 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.875) rad2) (polar pa (* 1.875 pi) rad2) colo2)
  (grdraw (polar pa 0 rad2) (polar pa pi rad2) colo2)
  (grdraw (polar pa (/ pi 2) rad2) (polar pa (* 1.5 pi) rad2) colo2)
  (grdraw (polar pa (* pi 0.75) (* rad 0.75))
          (polar pa (* pi 1.75) (* rad 0.75)) colo2)
  (grdraw (polar pa (* pi 0.25) (* rad 0.75))
          (polar pa (* pi 1.25) (* rad 0.75)) colo2)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Croco end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Horiz - put a list in order by the first number in each    
 ;   sublist.  Takes one argument, a list, which it returns in order       
 ;   from smallest to largest first element.                               
 ; 
 (DEFUN HORIZ (nexlst / low nxtsub hrzlst newlst orderd)
  (while nexlst
        (setq low (lowest nexlst))                 ; lowest leading number
        (while (and nexlst (setq nxtsub (nth 0 nexlst)))
               (if (equal low (read (car nxtsub)))
                   (setq hrzlst (append hrzlst (list nxtsub)))
                   (setq newlst (append newlst (list nxtsub))))
               (setq nexlst (cdr nexlst)))          ; remove 1st ent from list
        (setq orderd (append orderd hrzlst))        ; add lev sublst to levels
        (setq hrzlst ())                            ; set to () for next loop
        (setq nexlst newlst)                        ; nexlst reconstituted
        (setq newlst ()))                           ; empty new list & reuse
  orderd)
 ; Ŀ
 ;   Horiz end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lowest - find the smallest leading number in a sublist     
 ;   of the list Nexlst which is the sole argument.                        
 ; 
 (DEFUN LOWEST (nexlst / num minlst neth)
  (setq num 0)
  (setq minlst (list min))
  (while (setq neth (nth num nexlst))
         (if neth (setq minlst (append minlst (list (read (car neth))))))
         (setq num (1+ num)))
 (eval minlst))
 ; Ŀ
 ;   Lowest end.                                                           
 ; 

 ; Ŀ
 ;   Bomp.                                                                 
 ; 
 (DEFUN C:BOMP (/ ss num enam bomnum typl typr quant isstr sub subnum strsub
                                                               gnusub malist)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Get all material tag blocks.                                          
 ; 
  (setq ss (ssget "x" '((-4 . "<and") (0 . "insert") (66 . 1)
                                      (2 . "matltag,bomtag")
                        (-4 . "and>"))))
 ; Ŀ
 ;   Step through the selection set, count each type.                      
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (croco (cdr (assoc 10 (entget enam))))
         (setq num (1+ num))
         (setq bomnum (cdr (assoc 1 (entget (setq enam (entnext enam))))))
         (setq typl (cdr (assoc 1 (entget (setq enam (entnext enam))))))
         (setq typr (cdr (assoc 1 (entget (setq enam (entnext enam))))))
 ; Ŀ
 ;   Find which attribute contains the quantity, save it.                  
 ;   This is a bit kludgy.  Actually very.                                 
 ; 
         (setq quant ())
         (if (not (member typl '("" " " "  " "-" "..." "_")))
             (setq quant typl))
         (if (not (member typr '("" " " "  " "-" "..." "_")))
             (setq quant typr))
 ; Ŀ
 ;   Extract the number from the variable.                                 
 ; 
         (cond ((null quant)
                (setq quant 1))
               ((or (= (type (read quant)) 'INT)
                    (= (type (read quant)) 'REAL))
                (setq quant (read quant)))
               ((or (= (strcase (substr quant 1 3) t) "typ")
                    (and (= (strcase (substr quant 1 1) t) "a")
                         (= (strcase (substr quant 3 3) t) "r")))
                (setq quant "A/R"))
               ((= (strcase (substr quant 1 1) t) "x")
                (setq quant (read (substr quant 2))))
               (T (setq quant 1)))
 ; Ŀ
 ;   See if the Quant variable contains a string or a number.              
 ; 
         (if (= (type quant) 'STR)
             (setq isstr t)
             (setq isstr ()))
 ; Ŀ
 ;   Add the number tag or the tag and number to the master list.          
 ;   See if the second atom in the list is a string.                       
 ; 
         (setq sub (assoc bomnum malist))
         (setq subnum (cdr sub))
         (if (= (type subnum) 'STR)
             (setq strsub t)
             (setq strsub ()))
 ; Ŀ
 ;   Cond: the main number attribute was empty - ignore the block.         
 ; 
         (cond ((member bomnum '("" " " "  " "-" "..." "_")))
 ; Ŀ
 ;   Cond: there is a sublist matching the BOM No. and (quant is a string  
 ;   or subnum is a string.)                                               
 ; 
               ((and sub (or isstr strsub))
                (setq gnusub (cons (car sub) "A/R"))
                (setq malist (subst gnusub sub malist)))
 ; Ŀ
 ;   Cond: there is a sublist matching the BOM No. and Quant is a number   
 ;   and subnum is a number.                                               
 ; 
               ((and sub (null isstr) (null strsub))
                (setq gnusub (cons (car sub) (+ subnum quant)))
                (setq malist (subst gnusub sub malist)))
 ; Ŀ
 ;   Cond: there is no matching sublist.                                   
 ; 
               ((null sub)
                (setq gnusub (cons bomnum quant))
                (setq malist (cons gnusub malist)))))
 ; Ŀ
 ;   Malist should now contain all the bom data.                           
 ; 
  (setq malist (horiz malist))
 ; Ŀ
 ;   Print out the results.                                                
 ; 
  (setq num 0)
  (while (setq sub (nth num malist))
         (setq num (1+ num))
         (setq tagno (car sub))
         (if (= (type (setq totl (cdr sub))) 'int)
             (setq totl (itoa totl))
             (setq totl "No Total"))
         (write-line (strcat "Tag: " tagno "  Total: " totl)))
  (command "undo" "end")
 (princ))